/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.custom_portal_gen;

import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalExtension;
import qouteall.imm_ptl.core.portal.PortalManipulation;
import qouteall.imm_ptl.core.portal.nether_portal.BlockPortalShape;
import qouteall.imm_ptl.core.portal.nether_portal.BreakablePortalEntity;
import qouteall.imm_ptl.core.portal.nether_portal.NetherPortalGeneration;
import qouteall.q_misc_util.MiscHelper;
import qouteall.q_misc_util.my_util.DQuaternion;
import qouteall.q_misc_util.my_util.SignalArged;

public class PortalGenInfo {
    public static final SignalArged<PortalGenInfo> generatedSignal = new SignalArged();
    public class_5321<class_1937> from;
    public class_5321<class_1937> to;
    public BlockPortalShape fromShape;
    public BlockPortalShape toShape;
    @Nullable
    public DQuaternion rotation = null;
    public double scale = 1.0;

    public PortalGenInfo(class_5321<class_1937> from, class_5321<class_1937> to, BlockPortalShape fromShape, BlockPortalShape toShape) {
        this.from = from;
        this.to = to;
        this.fromShape = fromShape;
        this.toShape = toShape;
    }

    public PortalGenInfo(class_5321<class_1937> from, class_5321<class_1937> to, BlockPortalShape fromShape, BlockPortalShape toShape, DQuaternion rotation, double scale) {
        this.from = from;
        this.to = to;
        this.fromShape = fromShape;
        this.toShape = toShape;
        this.rotation = rotation;
        this.scale = scale;
        if (rotation != null && rotation.getRotatingAngleDegrees() < 0.001) {
            this.rotation = null;
        }
        if (Math.abs(this.scale - 1.0) < 1.0E-5) {
            this.scale = 1.0;
        }
    }

    public <T extends Portal> T createTemplatePortal(class_1299<T> entityType) {
        class_3218 fromWorld = McHelper.getServerWorld(this.from);
        Portal portal = (Portal)entityType.method_5883((class_1937)fromWorld);
        assert (portal != null);
        this.fromShape.initPortalPosAxisShape(portal, class_2350.class_2352.field_11056);
        portal.setDestDim(this.to);
        portal.setDestination(this.toShape.innerAreaBox.getCenterVec());
        portal.setScaling(this.scale);
        portal.setRotation(this.rotation);
        return (T)portal;
    }

    public <T extends BreakablePortalEntity> BreakablePortalEntity[] generateBiWayBiFacedPortal(class_1299<T> entityType) {
        BreakablePortalEntity f1 = (BreakablePortalEntity)this.createTemplatePortal(entityType);
        BreakablePortalEntity f2 = (BreakablePortalEntity)PortalManipulation.createFlippedPortal(f1, entityType);
        BreakablePortalEntity t1 = (BreakablePortalEntity)PortalManipulation.createReversePortal(f1, entityType);
        BreakablePortalEntity t2 = (BreakablePortalEntity)PortalManipulation.createFlippedPortal(t1, entityType);
        f1.blockPortalShape = this.fromShape;
        f2.blockPortalShape = this.fromShape;
        t1.blockPortalShape = this.toShape;
        t2.blockPortalShape = this.toShape;
        f1.reversePortalId = t1.method_5667();
        t1.reversePortalId = f1.method_5667();
        f2.reversePortalId = t2.method_5667();
        t2.reversePortalId = f2.method_5667();
        PortalExtension.initializeClusterBind(f1, f2, t1, t2);
        McHelper.spawnServerEntity(f1);
        McHelper.spawnServerEntity(f2);
        McHelper.spawnServerEntity(t1);
        McHelper.spawnServerEntity(t2);
        return new BreakablePortalEntity[]{f1, f2, t1, t2};
    }

    public void generatePlaceholderBlocks() {
        MinecraftServer server = MiscHelper.getServer();
        NetherPortalGeneration.fillInPlaceHolderBlocks(server.method_3847(this.from), this.fromShape);
        NetherPortalGeneration.fillInPlaceHolderBlocks(server.method_3847(this.to), this.toShape);
        generatedSignal.emit(this);
    }
}

